@extends('layout.master')
@section('title', 'Donation Details')
@section('content')
      <!-- donation details breadcrumb start -->
      <div class="wrapper-box p-relative">
        <div class="breadcrumb-bg" data-background="{{asset('assets/img/breadcrumb/breadcrumb-bg.png')}}"></div>
        <div class="breadcrumb-area pt-265 pb-265">
          <div class="container">
            <div class="row">
              <div class="col-xl-12">
                <div class="breadcrumb__content text-center">
                  <h1 class="breadcrumb__title">Donation details</h1>
                  <div class="breadcrumb__list">
                    <span><a href="{{ route('index')}}">Home</a></span>
                    <span class="dvdr"><i class="fa-solid fa-colon"></i></span>
                    <span class="underline">Campains details</span>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-- donation details breadcrumb end -->

      <!-- donation details area start -->
      <div class="donation-details-area pt-100 pb-90">
        <div class="container">
          <div class="row">
            <div class="col-lg-8">
              <div class="donation-details-item">
                <div class="donation-card-box donaion-details">
                  <div class="card-item">
                    <div class="tpcard__wrapper donation-details">
                      <div class="tpcard__thumb donation-details">
                        <img src="{{asset('assets/img/donation/donation-10.jpg')}}" alt="img" />
                      </div>
                      <div class="tpcard__content donation-details">
                        <h4 class="tpcard__title donation-details">Donate for African Child Education</h4>
                        <div class="tpcard__progresss">
                          <div class="progress donation-details">
                            <div
                              class="progress-bar donation-details"
                              role="progressbar"
                              aria-label="Example with label"
                              style="width: 65%"
                              aria-valuenow="25"
                              aria-valuemin="0"
                              aria-valuemax="100"
                            >
                              <span>80%</span>
                            </div>
                          </div>
                        </div>
                        <div class="tpcard__bottom d-flex justify-content-between">
                          <div class="tpcard__details donation-details">
                            <span class="subtitle">our goal</span> <br />
                            <span class="sale">$28.0000</span>
                          </div>
                          <div class="tpcard__details donation-details">
                            <span class="subtitle text-center">Raised</span> <br />
                            <span class="sale">$12.9098</span>
                          </div>
                          <div class="tpcard__details donation-details">
                            <span class="subtitle text-end">to go</span> <br />
                            <span class="sale">$58,000</span>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="donation-notice d-flex align-items-center">
                  <span
                    ><svg width="24" height="27" viewBox="0 0 24 27" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <path
                        fill-rule="evenodd"
                        clip-rule="evenodd"
                        d="M23.8236 24.6887L12.7561 5.96606C12.6007 5.69821 12.3114 5.5 12.0007 5.5C11.6847 5.5 11.3954 5.69821 11.2454 5.96606L0.177863 24.6887C0.0278673 24.9566 -0.0792725 25.3851 0.0760802 25.6476C0.231433 25.9101 0.515353 26.0708 0.826059 26.0708H23.1701C23.4808 26.0708 23.7647 25.9101 23.92 25.6476C24.0807 25.3851 23.9736 24.9512 23.8236 24.6887ZM13.7156 23.4995H10.2871V20.9281H13.7156V23.4995ZM13.7156 19.2139H10.2871V11.4998H13.7156V19.2139Z"
                        fill="black"
                      />
                      <mask id="mask0_413_2097" style="mask-type: alpha" maskUnits="userSpaceOnUse" x="0" y="5" width="24" height="22">
                        <path
                          fill-rule="evenodd"
                          clip-rule="evenodd"
                          d="M23.8236 24.6887L12.7561 5.96606C12.6007 5.69821 12.3114 5.5 12.0007 5.5C11.6847 5.5 11.3954 5.69821 11.2454 5.96606L0.177863 24.6887C0.0278673 24.9566 -0.0792725 25.3851 0.0760802 25.6476C0.231433 25.9101 0.515353 26.0708 0.826059 26.0708H23.1701C23.4808 26.0708 23.7647 25.9101 23.92 25.6476C24.0807 25.3851 23.9736 24.9512 23.8236 24.6887ZM13.7156 23.4995H10.2871V20.9281H13.7156V23.4995ZM13.7156 19.2139H10.2871V11.4998H13.7156V19.2139Z"
                          fill="white"
                        />
                      </mask>
                      <g mask="url(#mask0_413_2097)">
                        <rect y="3" width="24" height="24" fill="currentColor" />
                      </g>
                    </svg>
                  </span>
                  <span class="notice">Notice:</span>
                  <p>Test mode is enabled. While in test mode no live donations are processed.</p>
                </div>
                <div class="row">
                  <div class="col-xl-4">
                    <div class="donation-payment align-items-center mb-30">
                      <h3 class="donation-payment-title">Select Payment Method</h3>
                    </div>
                  </div>
                  <div class="col-xl-8">
                    <div class="donation-payment-check d-sm-flex justify-content-xxl-end mb-30">
                      <div class="form-check">
                        <input class="form-check-input" type="radio" name="exampleRadios" id="exampleRadios1" value="option1" checked />
                        <label class="form-check-label" for="exampleRadios1"> Test Donation </label>
                      </div>
                      <div class="form-check ml-30">
                        <input class="form-check-input" type="radio" name="exampleRadios" id="exampleRadios2" value="option1" checked />
                        <label class="form-check-label" for="exampleRadios2"> Cradint Donation </label>
                      </div>
                      <div class="form-check ml-30">
                        <input class="form-check-input" type="radio" name="exampleRadios" id="exampleRadios3" value="option1" checked />
                        <label class="form-check-label" for="exampleRadios3"> Offline Donation </label>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="row">
                  <div class="col-xl-4">
                    <div class="donation-payment-method mb-30">
                      <input type="text" placeholder="Enter your ammount" />
                    </div>
                  </div>
                  <div class="col-xl-8">
                    <div class="donation-payment-method d-flex flex-wrap justify-content-xxl-end mb-30">
                      <button type="button">$20</button>
                      <button type="button">$50</button>
                      <button type="button">$100</button>
                      <button type="button">$500</button>
                      <button type="button">$1000</button>
                    </div>
                  </div>
                </div>
                <div class="donation-error-notification p-relative">
                  <span
                    ><i class="fa-sharp fa-solid fa-circle-xmark"></i>We're unable to recognize your session.Please refresh the screen to try again; otherwise contact your website
                    administrator for assistance.
                  </span>
                  <div class="donation-btn">
                    <a class="tp-btn tp-btn-shine-effect" href="{{ route('donation-details')}}">Donate now</a>
                  </div>
                </div>
                <div class="donation-details-text mt-60">
                  <p class="mb-30">
                    We have covered many special events such as fireworks, fairs, parades, races, walks, awards ceremonies, fashion shows, sporting events, and even a memorial
                    service.
                  </p>
                  <p class="mb-30">
                    Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur vulputate vestibulum rhoncus, dolor eget viverra pretium, dolor tellus aliquet nunc, vitae
                    ultricies erat elit eu lacus. Vestibulum non justo consectetur, cursus ante, tincidunt sapien. Nulla quis diam sit amet turpis interd enim. Vivamus faucibus ex
                    sed nibh egestas elementum. Mauris et bibendum dui. Aenean consequat pulvinar luctus. Suspendisse consectetur tristique tortor
                  </p>
                  <h3 class="donation-payment-title">Our challenge & Goal</h3>
                  <p class="mb-30">
                    Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur vulputate vestibulum Phasellus rhoncus, dolor eget viverra pretium, dolor tellus aliquet
                    nunc, vitae ultricies erat elit eu lacus. Vestibulum non justo consectetur, cursus ante, tincidunt sapien. Nulla quis diam sit amet turpis interdum accumsan
                    quis nec enim. Vivamus faucibus ex sed nibh egestas elementum. Mauris et bibendum dui. Aenean consequat pulvinar luctus
                  </p>
                  <p class="mb-30">
                    We have covered many special events such as fireworks, fairs, parades, races, walks, awards ceremonies, fashion shows, sporting events, and even a memorial
                    service.
                  </p>
                  <p class="mb-30">
                    Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur vulputate vestibulum Phasellus rhoncus, dolor eget viverra pretium, dolor tellus aliquet
                    nunc, vitae ultricies erat elit eu lacus. Vestibulum non justo consectetur, cursus ante, tincidunt sapien. Nulla quis diam sit amet turpis interdum accumsan
                    quis nec enim. Vivamus faucibus ex sed nibh egestas elementum. Mauris et bibendum dui. Aenean consequat pulvinar luctus. Suspendisse consectetur tristique
                    tortor
                  </p>
                </div>
              </div>
            </div>
            <div class="col-lg-4">
              <div class="right-padding pl-25">
                <div class="sidebar__widget donation-details mb-40">
                  <h3 class="sidebar__widget-title donation-details">Categories</h3>
                  <div class="sidebar__widget-content donation-details">
                    <ul>
                      <li>
                        <a href="{{ route('donation-listing')}}">Education <span>03</span></a>
                      </li>
                      <li>
                        <a href="{{ route('donation-listing')}}">Hetalth care <span>07</span></a>
                      </li>
                      <li>
                        <a href="{{ route('donation-listing')}}">Food and water <span>09</span></a>
                      </li>
                      <li>
                        <a href="{{ route('donation-listing')}}">Chemistry <span>01</span></a>
                      </li>
                      <li>
                        <a href="{{ route('donation-listing')}}">UI/UX Deisgn <span>00</span></a>
                      </li>
                      <li>
                        <a href="{{ route('donation-listing')}}">Gemological <span>26</span></a>
                      </li>
                    </ul>
                  </div>
                </div>
                <div class="sidebar__widget-contact">
                  <h3 class="sidebar__widget-title donation-details contact">Direct Contact us</h3>
                  <input type="text" placeholder="Enter name*" />
                  <input type="email" placeholder="Enter your mail*" />
                  <input type="text" placeholder="Message*" />
                  <div class="sidebar-btn">
                    <button class="tp-btn tp-btn-shine-effect">send message</button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-- Blog details area end -->
  
@endsection