@extends('layout.master')
@section('title', 'Donation Listing')
@section('content')
      <!-- donation listing breadcrumb start -->
      <div class="wrapper-box p-relative">
        <div class="breadcrumb-bg" data-background="{{asset('assets/img/breadcrumb/breadcrumb-bg.png')}}"></div>
        <div class="breadcrumb-area pt-265 pb-230">
          <div class="container">
            <div class="row">
              <div class="col-xl-12">
                <div class="breadcrumb__content text-center">
                  <h1 class="breadcrumb__title">Donation listing</h1>
                  <div class="breadcrumb__list">
                    <span><a href="{{ route('index')}}">Home</a></span>
                    <span class="dvdr"><i class="fa-solid fa-colon"></i></span>
                    <span class="underline">Donation listing</span>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-- donation listing breadcrumb end -->

      <section class="donation-list-area pt-100 pb-130">
        <div class="container">
          <div class="row">
            <div class="col-md-6 wow fadeInLeft" data-wow-duration="1s" data-wow-delay=".3s">
              <div class="vertically_center">
                <h2>Donate</h2>
                <p>
                  You have the power to transform lives. Any contribution, big or small, goes a long way. You can donate to any project that is close to your heart. You can donate
                  anonymously, in your name, or to honor someone that you love.
                </p>
                <p>
                  In times of crisis and urgency, funds that are not tied to a specific cause or person <br />
                  help us stay afloat.
                </p>
              </div>
            </div>
            <div class="col-md-6 wow fadeInRight" data-wow-duration="1s" data-wow-delay=".3s">
              <div>
                <img class="w-100" src="{{asset('assets/img/donation/donation.jpg')}}" alt="img" />
              </div>
            </div>
          </div>
        </div>
      </section>

      <!-- donation listing area start -->
      <div class="donation-list-area pt-100 pb-130">
        <div class="container">
          <h2 class="text-center pb-80">Specific Cause</h2>
          <div class="row tp-gx-20">
            <div class="col-md-6 wow fadeInLeft" data-wow-duration="1s" data-wow-delay=".3s">
              <div class="bg_light_blue p-4 rounded">
                <div class="mt-4 text-center">
                  <h4>Support the Kiran Ambassador Program</h4>
                  <p>Bridge the gap by supporting children study in mainstream school</p>
                </div>
                <div class="mt-4 text-center">
                  <h4>Support the Mental Health & Wellbeing Support</h4>
                  <p>Help a person recover from trauma and end the stigma around mental health by sponsoring counsellors or mental health practitioners.</p>
                </div>
                <div class="mt-4 text-center">
                  <h4>Support the Hadia BTS</h4>
                  <p>Give children the opportunity to find their strengths and talents by sponsoring a club.</p>
                </div>
                <div class="mt-4 text-center">
                  <h4>Support the Nafeesa Forum</h4>
                  <p>Empower mothers by helping them continue their education and learn new skills.</p>
                </div>
                <div class="mt-4 text-center">
                  <h4>Contribute to our scholarship fund</h4>
                  <p>And help a high potential student pursue a degree.</p>
                </div>
              </div>
            </div>
            <div class="col-md-6 wow fadeInRight" data-wow-duration="1s" data-wow-delay=".3s">
              <div class="bg_light_green p-4 rounded">
                <div class="mt-4 text-center">
                  <h4>Donate to Community Welfare</h4>
                  <p>Help a family come out of crisis by giving them ration or shelter. Make the pains of treatment more bearable by relieving some of the burden of bills.</p>
                </div>
                <div class="mt-4 text-center">
                  <h4>Sponsor a van</h4>
                  <p>And make it easier for students to have exposure visits & fields trips, and for more staff members to come to Lyari.</p>
                </div>
                <div class="mt-4 text-center">
                  <h4>Sponsor a facility</h4>
                  <p>There are just not enough well-stocked libraries laboratories for children. Help us restore facilities in more Govt schools.</p>
                </div>
                <div class="mt-4 text-center">
                  <h4>Contribute to our endowment fund</h4>
                  <p>And invest in the long-term sustainability of the organization.</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-- donation listing area end -->

      <!-- donation listing area start -->
      <div class="donation-list-area pb-130">
        <div class="container">
          <h2 class="text-center pb-80">Specific Person</h2>
          <div class="row tp-gx-20">
            <div class="col-md-6 wow fadeInLeft" data-wow-duration="1s" data-wow-delay=".3s">
              <div class="bg_light_green p-4 rounded">
                <div class="mt-4 text-center">
                  <h4>PKR 120,000 – 220,000 PER YEAR</h4>
                  <p>Bridge the gap by sponsoring a child in mainstream Cambridge or Agha khan Board school. This includes transport, coursework, tuition fees, and uniform.</p>
                </div>
                <div class="mt-4 text-center">
                  <h4>PKR 1500 PER MONTH</h4>
                  <p>Support Kiran Ambassador Program by sponsoring a child for the evening school.</p>
                </div>
                <div class="mt-4 text-center">
                  <h4>PKR 15000 PER YEAR</h4>
                  <p>Nurture a neglected mother to believe in her talents and abilities to be as groomed and eloquent as women of the privileged class.</p>
                </div>
              </div>
            </div>
            <div class="col-md-6 wow fadeInRight" data-wow-duration="1s" data-wow-delay=".3s">
              <div class="bg_light_blue p-4 rounded">
                <div class="mt-4 text-center">
                  <h4>PKR 80,000 PER YEAR</h4>
                  <p>Empower single women and young entrepreneurs to learn techniques and crafts, helping them establish their own business.</p>
                </div>
                <div class="mt-4 text-center">
                  <h4>PKR 18000 PER YEAR</h4>
                  <p>Support Hadia Beyond the School by sponsoring a child.</p>
                </div>
                <div class="mt-4 text-center">
                  <h4>PKR 42000 PER YEAR</h4>
                  <p>Support a child in DCTO campus. This covers the per child cost at Kiran School System which is implemented at the DCTO government school.</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-- donation listing area end -->

      <!-- donation listing area start -->
      <div class="donation-list-area pb-130">
        <div class="container">
          <div class="row tp-gx-20 bg_light_grey">
            <div class="col-md-6 wow fadeInLeft" data-wow-duration="1s" data-wow-delay=".3s">
              <div class="p-4 rounded">
                <h3>For International Donors</h3>
                <div class="mt-4">
                  <h4>Kiran Foundation – US</h4>
                  <p class="mb-1">422 Harrison drive, Hockessin, DE 19707</p>
                  <p class="mb-1">PNC Bank Checking Account 5695049988</p>
                  <p class="mb-1">Routing Number 031100089</p>
                </div>
              </div>
            </div>
            <div class="col-md-6 wow fadeInRight" data-wow-duration="1s" data-wow-delay=".3s">
              <div class="p-4 rounded">
                <h3>For Local Donors</h3>
                <div class="mt-4">
                  <h4>Muhammad Jawad Zahid</h4>
                  <p class="mb-1">Financial Controller</p>
                  <p class="mb-1">+92 334 3353606</p>
                  <p class="mb-1">finance@kiranschool.com</p>
                </div>
                <div class="mt-4">
                  <h4>For Non-Zakat General Donations</h4>
                  <p class="mb-1">Account Title: Kiran Foundation – Flagship</p>
                  <p class="mb-1">Meezan Bank</p>
                  <p class="mb-1">A/C No.: 0102112535</p>
                  <p class="mb-1">IBAN: PK32 MEZN 0001 5401 0211 2535</p>
                  <p class="mb-1">Gul Bai SITE Area Branch, Karachi, Pakistan</p>
                </div>
                <div class="mt-4">
                  <h4>For General Zakat</h4>
                  <p class="mb-1">Account Title: Kiran Foundation (Zakat)</p>
                  <p class="mb-1">Meezan Bank, Gul Bai Branch, SITE Area</p>
                  <p class="mb-1">Account # 0154 0101419872</p>
                  <p class="mb-1">IBAN: PK42 MEZN 0001 5401 0141 9872</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    @endsection