@extends('layout.master')
@section('title', 'Health Screening BICPHS')
@section('content')
      <!-- about foundation area start -->
      <div class="wrapper-box p-relative">
        <div class="breadcrumb-bg" data-background="{{asset('assets/img/breadcrumb/breadcrumb-bg.png')}}"></div>
        <div class="breadcrumb-area pt-265 pb-265">
          <div class="container">
            <div class="row">
              <div class="col-xl-12">
                <div class="breadcrumb__content text-center">
                  <h1 class="breadcrumb__title">Health Screening</h1>
                  <div class="breadcrumb__list">
                    <span><a href="{{ route('index')}}">Home</a></span>
                    <span class="dvdr"><i class="fa-solid fa-colon"></i></span>
                    <span class="underline">Health Screening</span>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-- about foundation area end -->



      <!-- volunteers area 4 start -->
      <section class="volunteers-area-3 pt-20 pb-115 mt-50 mt-md-0">
        <div class="container">
          <div class="row image_reverse align-items-center">
            <div class="col-xl-7 col-lg-7 col-md-12">
              <div class="volunteers-section-3__wrapper volunteers-breadcrumb mt-80">
                <!-- <span class="section-sub-title has-before wow fadeInLeft" data-wow-duration="1s"
                        data-wow-delay=".3s"> About us</span> -->
                <!--<h3 class="section-title wow fadeInLeft" data-wow-duration="1s" data-wow-delay=".5s">Dummy Text Dummy</h3>-->
                <p class="wow fadeInLeft" data-wow-duration="1s" data-wow-delay=".5s">In schools, health screenings play a vital role in promoting the overall well-being of students. Conducted by trained healthcare professionals, these screenings aim to identify potential health issues early on, ensuring that students receive timely interventions and support. Typically encompassing vision and hearing tests, height and weight measurements, and assessments of basic physical health, these screenings serve as preventive measures to address any concerns that might affect a student's academic performance or daily life. Schools often collaborate with local healthcare providers to implement comprehensive health screening programs, fostering a holistic approach to student health. Through these screenings, educators and parents gain valuable insights into a child's health status, enabling them to work collaboratively in creating a supportive environment for optimal learning and growth.
                </p>
                <div class="tpcta-4-btn wow fadeInLeft" data-wow-duration="1s" data-wow-delay=".9s">
                  <!-- <a class="tp-btn tp-btn-shine-effect" href="contact-us.html">Became a volenteer</a> -->
                </div>
              </div>
            </div>
            <div class="col-xl-5 col-lg-5 col-md-12">
              <div class="tpvolunteers__thumb p-relative wow fadeInRight" data-wow-duration="1s" data-wow-delay=".5s">
                <div class="tpvolunteers-3__img-1">
                  <img class="object_fit_cover mx-auto d-block" src="{{asset('assets/img/service/health-screening.webp')}}" alt="img" />
                </div>
                <!-- <div class="tpvolunteers-3__img-2">
                        <img src="assets/img/about/home1/volunteers2.png" alt="img">
                     </div> -->
              </div>
            </div>
          </div>
        </div>
      </section>
      <!-- volunteers area 4 end -->


      
@endsection